unit MDIEdit;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls, ComCtrls;

type
  TEditForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    Print1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Delete1: TMenuItem;
    N3: TMenuItem;
    Selectall1: TMenuItem;
    Character1: TMenuItem;
    Left1: TMenuItem;
    Right1: TMenuItem;
    Center1: TMenuItem;
    N4: TMenuItem;
    Wordwrap1: TMenuItem;
    N5: TMenuItem;
    Font1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Cut2: TMenuItem;
    Copy2: TMenuItem;
    Paste2: TMenuItem;
    SaveFileDialog: TSaveDialog;
    FontDialog1: TFontDialog;
    Printersetup1: TMenuItem;
    Close1: TMenuItem;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PrintDialog1: TPrintDialog;
    Editor: TRichEdit;
    procedure Exit1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure AlignClick(Sender: TObject);
    procedure Wordwrap1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Selectall1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure Printersetup1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
  private
    { Private declarations }
    PathName: string;
{$IFDEF CLR}
		procedure InitializeControls;
{$ENDIF}
  public
    { Public declarations }
    procedure Open(const AFileName: string);
{$IFDEF CLR}
		constructor Create(AOwner: TComponent); override;
{$ENDIF}
  end;

var
  EditForm: TEditForm;

const
  DefaultFileName = 'Untitled';

implementation

uses
	 Clipbrd, Printers, MDIFrame;


procedure TEditForm.Exit1Click(Sender: TObject);
begin
  FrameForm.Exit1Click(Sender);
end;

procedure TEditForm.New1Click(Sender: TObject);
begin
  FrameForm.New1Click(Sender);
end;

procedure TEditForm.Open1Click(Sender: TObject);
begin
  FrameForm.Open1Click(Sender);
end;

procedure TEditForm.AlignClick(Sender: TObject);
begin
  Left1.Checked := False;
  Right1.Checked := False;
  Center1.Checked := False;
  with Sender as TMenuItem do Checked := True;
  with Editor.Paragraph do
    if Left1.Checked then
      Alignment := taLeftJustify
    else if Right1.Checked then
      Alignment := taRightJustify
    else if Center1.Checked then
      Alignment := taCenter;
end;

procedure TEditForm.Wordwrap1Click(Sender: TObject);
begin
  with Editor do
  begin
    WordWrap := not WordWrap; { toggle word wrapping }
    if WordWrap then
      ScrollBars := ssVertical
    else
      ScrollBars := ssBoth;
    WordWrap1.Checked := WordWrap; { set menu item check }
  end;
end;

procedure TEditForm.Cut1Click(Sender: TObject);
begin
  Editor.CutToClipboard;
end;

procedure TEditForm.Copy1Click(Sender: TObject);
begin
  Editor.CopyToClipboard;
end;

procedure TEditForm.Paste1Click(Sender: TObject);
begin
  Editor.PasteFromClipboard;
end;

procedure TEditForm.Selectall1Click(Sender: TObject);
begin
  Editor.SelectAll;
end;

procedure TEditForm.Delete1Click(Sender: TObject);
begin
  Editor.ClearSelection;
end;

procedure TEditForm.Edit1Click(Sender: TObject);
var
  HasSelection: Boolean;
begin
  Paste1.Enabled := Clipboard.HasFormat(CF_TEXT);
  Paste2.Enabled := Paste1.Enabled;
  HasSelection := Editor.SelLength > 0;
  Cut1.Enabled := HasSelection;
  Cut2.Enabled := HasSelection;
  Copy1.Enabled := HasSelection;
  Copy2.Enabled := HasSelection;
  Delete1.Enabled := HasSelection;
end;

procedure TEditForm.Open(const AFileName: string);
begin
  PathName := AFileName;
  Caption := ExtractFileName(AFileName);
  with Editor do
  begin
    Lines.LoadFromFile(PathName);
    SelStart := 0;
    Modified := False;
  end;
end;

procedure TEditForm.Saveas1Click(Sender: TObject);
begin
  SaveFileDialog.FileName := PathName;
  if SaveFileDialog.Execute then
  begin
    PathName := SaveFileDialog.FileName;
    Caption := ExtractFileName(PathName);
    Save1Click(Sender);
  end;
end;

procedure TEditForm.Save1Click(Sender: TObject);
begin
  if PathName = DefaultFileName then
    SaveAs1Click(Sender)
  else
  begin
    Editor.Lines.SaveToFile(PathName);
    Editor.Modified := False;
  end;
end;

procedure TEditForm.Font1Click(Sender: TObject);
begin
  FontDialog1.Font := Editor.Font;
  if FontDialog1.Execute then
    Editor.SelAttributes.Assign(FontDialog1.Font);
end;

procedure TEditForm.Close1Click(Sender: TObject);
begin
  Close;
end;

procedure TEditForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TEditForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
const
  SWarningText = 'Save changes to %s?';
begin
  if Editor.Modified then
  begin
    case MessageDlg(Format(SWarningText, [PathName]), mtConfirmation,
      [mbYes, mbNo, mbCancel], 0) of
      idYes: Save1Click(Self);
      idCancel: CanClose := False;
    end;
  end;
end;

procedure TEditForm.FormCreate(Sender: TObject);
begin
  PathName := DefaultFileName;
end;

procedure TEditForm.Printersetup1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TEditForm.Print1Click(Sender: TObject);
begin
  if PrintDialog1.Execute then
    Editor.Print(PathName);
end;

{$IFDEF CLR}
constructor TEditForm.Create(AOwner: TComponent);
begin
	inherited CreateNew(AOwner);
	InitializeControls;
end;
{$ENDIF}
{$IFDEF CLR}
procedure TEditForm.InitializeControls;
begin
  // Initalizing all controls...
	Editor:= TRichEdit.Create(Self);
	MainMenu1:= TMainMenu.Create(Self);
	File1:= TMenuItem.Create(Self);
	New1:= TMenuItem.Create(Self);
	Open1:= TMenuItem.Create(Self);
	Close1:= TMenuItem.Create(Self);
	Save1:= TMenuItem.Create(Self);
	Saveas1:= TMenuItem.Create(Self);
	Print1:= TMenuItem.Create(Self);
	Printersetup1:= TMenuItem.Create(Self);
	N2:= TMenuItem.Create(Self);
	Exit1:= TMenuItem.Create(Self);
	Edit1:= TMenuItem.Create(Self);
	Cut1:= TMenuItem.Create(Self);
	Copy1:= TMenuItem.Create(Self);
	Paste1:= TMenuItem.Create(Self);
	Delete1:= TMenuItem.Create(Self);
	N3:= TMenuItem.Create(Self);
	Selectall1:= TMenuItem.Create(Self);
	Character1:= TMenuItem.Create(Self);
	Left1:= TMenuItem.Create(Self);
	Right1:= TMenuItem.Create(Self);
	Center1:= TMenuItem.Create(Self);
	N4:= TMenuItem.Create(Self);
	Wordwrap1:= TMenuItem.Create(Self);
	N5:= TMenuItem.Create(Self);
	Font1:= TMenuItem.Create(Self);
	PopupMenu1:= TPopupMenu.Create(Self);
	Cut2:= TMenuItem.Create(Self);
	Copy2:= TMenuItem.Create(Self);
	Paste2:= TMenuItem.Create(Self);
	SaveFileDialog:= TSaveDialog.Create(Self);
	FontDialog1:= TFontDialog.Create(Self);
	PrinterSetupDialog1:= TPrinterSetupDialog.Create(Self);
	PrintDialog1:= TPrintDialog.Create(Self);
	
	with Editor do
	begin
		Parent:= Self;
		Left:= 0;
		Top:= 0;
		Width:= 427;
		Height:= 254;
		Align:= alClient;
		TabOrder:= 0;
	end;
	
	with MainMenu1 do
	begin
		Parent:= Self;
	end;
	
	with File1 do
	begin
		MainMenu1.Items.Add(File1);
		Caption:= '&File';
	end;
	
	with New1 do
	begin
		File1.Add(New1);
		Caption:= '&New';
		OnClick:= New1Click;
	end;
	
	with Open1 do
	begin
		File1.Add(Open1);
		Caption:= '&Open...';
		OnClick:= Open1Click;
	end;
	
	with Close1 do
	begin
		File1.Add(Close1);
		Caption:= '&Close';
		OnClick:= Close1Click;
	end;
	
	with Save1 do
	begin
		File1.Add(Save1);
		Caption:= '&Save';
		OnClick:= Save1Click;
	end;
	
	with Saveas1 do
	begin
		File1.Add(Saveas1);
		Caption:= 'Save &as...';
		OnClick:= Saveas1Click;
	end;
	
	with Print1 do
	begin
		File1.Add(Print1);
		Caption:= '&Print';
		OnClick:= Print1Click;
	end;
	
	with Printersetup1 do
	begin
		File1.Add(Printersetup1);
		Caption:= 'Printer setup...';
		OnClick:= Printersetup1Click;
	end;
	
	with N2 do
	begin
		File1.Add(N2);
		Caption:= '-';
	end;
	
	with Exit1 do
	begin
		File1.Add(Exit1);
		Caption:= 'E&xit';
		OnClick:= Exit1Click;
	end;
	
	with Edit1 do
	begin
		MainMenu1.Items.Add(Edit1);
		Caption:= '&Edit';
		GroupIndex:= 1;
		OnClick:= Edit1Click;
	end;
	
	with Cut1 do
	begin
		Edit1.Add(Cut1);
		Caption:= 'Cu&t';
		ShortCut:= 16472;
		OnClick:= Cut1Click;
	end;
	
	with Copy1 do
	begin
		Edit1.Add(Copy1);
		Caption:= '&Copy';
		ShortCut:= 16451;
		OnClick:= Copy1Click;
	end;
	
	with Paste1 do
	begin
		Edit1.Add(Paste1);
		Caption:= '&Paste';
		ShortCut:= 16470;
		OnClick:= Paste1Click;
	end;
	
	with Delete1 do
	begin
		Edit1.Add(Delete1);
		Caption:= 'De&lete';
		ShortCut:= 16452;
		OnClick:= Delete1Click;
	end;
	
	with N3 do
	begin
		Edit1.Add(N3);
		Caption:= '-';
	end;
	
	with Selectall1 do
	begin
		Edit1.Add(Selectall1);
		Caption:= 'Select &all';
		ShortCut:= 16449;
		OnClick:= Selectall1Click;
	end;
	
	with Character1 do
	begin
		MainMenu1.Items.Add(Character1);
		Caption:= '&Character';
		GroupIndex:= 1;
	end;
	
	with Left1 do
	begin
		Character1.Add(Left1);
		Caption:= '&Left';
		Checked:= True;
		OnClick:= AlignClick;
	end;
	
	with Right1 do
	begin
		Character1.Add(Right1);
		Caption:= '&Right';
		OnClick:= AlignClick;
	end;
	
	with Center1 do
	begin
		Character1.Add(Center1);
		Caption:= '&Center';
		OnClick:= AlignClick;
	end;
	
	with N4 do
	begin
		Character1.Add(N4);
		Caption:= '-';
	end;
	
	with Wordwrap1 do
	begin
		Character1.Add(Wordwrap1);
		Caption:= '&Word wrap';
		Checked:= True;
		OnClick:= Wordwrap1Click;
	end;
	
	with N5 do
	begin
		Character1.Add(N5);
		Caption:= '-';
	end;
	
	with Font1 do
	begin
		Character1.Add(Font1);
		Caption:= '&Font...';
		OnClick:= Font1Click;
	end;
	
	with PopupMenu1 do
	begin
		Parent:= Self;
		OnPopup:= Edit1Click;
	end;
	
	with Cut2 do
	begin
		PopupMenu1.Items.Add(Cut2);
		Caption:= 'Cu&t';
		OnClick:= Cut1Click;
	end;
	
	with Copy2 do
	begin
		PopupMenu1.Items.Add(Copy2);
		Caption:= '&Copy';
		OnClick:= Copy1Click;
	end;
	
	with Paste2 do
	begin
		PopupMenu1.Items.Add(Paste2);
		Caption:= '&Paste';
		OnClick:= Paste1Click;
	end;
	
	with SaveFileDialog do
	begin
		Parent:= Self;
		Filter:=  'Rich text files (*.rtf)|*.rtf|Plain text files (*.txt)|*.txt|All' +
		  ' files|*.*';
		Options:= [ofHideReadOnly, ofFileMustExist, ofNoReadOnlyReturn];
	end;
	
	with FontDialog1 do
	begin
		Parent:= Self;
		Font.Charset:= DEFAULT_CHARSET;
		Font.Color:= clWindowText;
		Font.Height:= -11;
		Font.Name:= 'MS Sans Serif';
		Font.Style:= [];
	end;
	
	with PrinterSetupDialog1 do
	begin
		Parent:= Self;
		Left:= 208;
		Top:= 24;
	end;
	
	with PrintDialog1 do
	begin
		Parent:= Self;
	end;

	// Form's PMEs'
	Left:= 608;
	Top:= 451;
	Width:= 435;
	Height:= 308;
	Caption:= 'Untitled';
	Color:= clBtnFace;
	Font.Charset:= DEFAULT_CHARSET;
	Font.Color:= clWindowText;
	Font.Height:= -11;
	Font.Name:= 'MS Sans Serif';
	Font.Style:= [];
	FormStyle:= fsMDIChild;
	Menu:= MainMenu1;
	PopupMenu:= PopupMenu1;
	Position:= poDefault;
	Visible:= True;
	OnClose:= FormClose;
	OnCloseQuery:= FormCloseQuery;
	OnCreate:= FormCreate;
end;
{$ENDIF}
end.
